definition module StdPictureDef


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.0.1
//	
//	StdPictureDef contains the predefined figures that can be drawn.
//	********************************************************************************

import	StdIOCommon, StdFont


::	Box										// A box is a rectangle
	=	{	box_w			:: !Int			// The width  of the box
		,	box_h			:: !Int			// The height of the box
		}
::	Oval									// An oval is a stretched unit circle
	=	{	oval_rx			:: !Int			// The horizontal radius (stretch)
		,	oval_ry			:: !Int			// The vertical   radius (stretch)
		}
::	Curve									// A curve is a slice of an oval
	=	{	curve_oval		:: !Oval		// The source oval
		,	curve_from		:: !Real		// Starting angle (in radians)
		,	curve_to		:: !Real		// Ending   angle (in radians)
		,	curve_clockwise	:: !Bool		// Direction: True iff clockwise
		}
::	Polygon									// A polygon is an outline shape
	=	{	polygon_shape	:: ![Vector]	// The shape of the polygon
		}


//	The picture attributes:
::	PictureAttribute						// Default:
	=	PicturePenSize		Int				// 1
	|	PicturePenPos		Point			// zero
	|	PicturePenColour	Colour			// Black
	|	PicturePenFont		Font			// DefaultFont
::	Colour
	=	RGB RGBColour
	|	Black		| White
	|	DarkGrey	| Grey		| LightGrey	// 75%, 50%, and 25% Black
	|	Red			| Green		| Blue
	|	Cyan		| Magenta	| Yellow
::	RGBColour
	=	{	r	:: !Int						// The contribution of red
		,	g	:: !Int						// The contribution of green
		,	b	:: !Int						// The contribution of blue
		}
BlackRGB	:==	{r=MinRGB,g=MinRGB,b=MinRGB}
WhiteRGB	:==	{r=MaxRGB,g=MaxRGB,b=MaxRGB}
MinRGB		:== 0
MaxRGB		:== 255

PI			:== 3.1415926535898
